<?php
// If it's going to need the database, then it's 
// probably smart to require it before we start.
require_once('database.php');

class Employee extends DatabaseObject {
	
	protected static $table_name="employee";
	protected static $db_fields = array('id', 'emp_code', 'zone', 'circle', 'state', 'location', 'emp_id', 'emp_name', 'emp_contact', 'emp_email', 'emp_aadhar_no', 'emp_designation', 
	  'emp_type', 'emp_joining_date', 'emp_resignation_date', 'store_dealer_code', 'store_name', 'store_location', 'store_city', 'channel_partner_code', 'channel_partner_name', 
	  'company_id', 'gst_no', 'level_1', 'level_2', 'level_3_a', 'level_3_b', 'level_4', 'face_id_1', 'face_id_2', 'face_id_3', 'lat', 'lon', 'accuracy', 'mark_in', 'mark_out', 'week_off', 'face_id_status', 'status', 
	  'approved_by', 'updated_by', 'updated_at', '_date', '_time', 'password', 'devId','privacy_policy','face_verify');
	
	public $id;
	public $emp_code;
	public $zone;
	public $circle;
	public $state;
	public $location;
	public $emp_id;
	public $emp_name;
	public $emp_contact;
	public $emp_email;
	public $emp_aadhar_no;
	public $emp_designation;
	public $emp_type;
	public $emp_joining_date;
	public $emp_resignation_date;
	public $store_dealer_code;
	public $store_name;
	public $store_location;
	public $store_city;
	public $channel_partner_code;
	public $channel_partner_name;
	public $company_id;
	public $gst_no;
	public $level_1;
	public $level_2;
	public $level_3_a;
	public $level_3_b;
	public $level_4;
	public $face_id_1;
	public $face_id_2;
	public $face_id_3;
	public $lat;
	public $lon;
	public $accuracy;
	public $mark_in;
	public $mark_out;
	public $week_off;
	public $face_id_status;
	public $status;
	public $approved_by;
	public $updated_by;
	public $updated_at;
	public $_date;
	public $_time;
	public $password;
	public $devId;
	public $privacy_policy;
    public $face_verify;

	public static function authenticate($user_name="", $password="") {
        global $database;
        $user_name 	= $database->escape_value($user_name);
        $password = $database->escape_value($password);
    
        $sql  = "SELECT id, emp_code, emp_name, emp_contact, face_id_1, face_id_status, status, password FROM ".self::$table_name;
        $sql .= " WHERE emp_code = '{$user_name}' ";
        $sql .= "AND password = '{$password}' ";
        $sql .= "LIMIT 1";
        $result_array = self::find_by_sql($sql);
		return !empty($result_array) ? array_shift($result_array) : false;
	}
	
	
	public static function authenticate_mobile($mobile) {
        global $database;
        $mobile 	= $database->escape_value($mobile);

        $sql  = "SELECT emp_contact FROM ".self::$table_name;
        $sql .= " WHERE emp_contact = '{$mobile}' ";
        $sql .= "LIMIT 1";
        $result_array = self::find_by_sql($sql);
		return !empty($result_array) ? array_shift($result_array) : false;
	}
	
	public static function getEmployeeData($emp_code) {
        global $database;
        $emp_code 	= $database->escape_value($emp_code);

        $sql  = "SELECT *, NULL AS password FROM ".self::$table_name;
        $sql .= " WHERE emp_code = '{$emp_code}' ";
        $sql .= "LIMIT 1";
        $result_array = self::find_by_sql($sql);
		return !empty($result_array) ? array_shift($result_array) : false;
	}
	
	public static function authenticate_user($emp_code) {
        global $database;
        $emp_code 	= $database->escape_value($emp_code);

        $sql  = "SELECT *, NULL AS password FROM ".self::$table_name;
        $sql .= " WHERE emp_code = '{$emp_code}' ";
        $sql .= "LIMIT 1";
        $result_array = self::find_by_sql($sql);
		return !empty($result_array) ? array_shift($result_array) : false;
	}
	
	public static function authenticate_emp_code($emp_code) {
        global $database;
        $cust_code 	= $database->escape_value($emp_code);

        $sql  = "SELECT id, emp_code, emp_contact, status, devId FROM ".self::$table_name;
        $sql .= " WHERE emp_code = '{$cust_code}' ";
        $sql .= "LIMIT 1";
        $result_array = self::find_by_sql($sql);
		return !empty($result_array) ? array_shift($result_array) : false;
	}
	
	
	// Common Database Methods
	public static function find_all() {
		return self::find_by_sql("SELECT * FROM ".self::$table_name);
    }

    public static function find_by_company_id($cid) {
		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE emp_code LIKE '{$cid}%' order by emp_name ASC");
    }
  
    public static function find_by_id($id=0) {
        $result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE id={$id} LIMIT 1");
    	return !empty($result_array) ? array_shift($result_array) : false;
    }
    
    public static function find_by_emp_code($emp_code) {
        $result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE emp_code={$emp_code} LIMIT 1");
    	return !empty($result_array) ? array_shift($result_array) : false;
    }
  
    public static function find_by_id_empid($id, $emp_id) {
        $result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE id={$id} AND emp_id={$emp_id} LIMIT 1");
		return !empty($result_array) ? array_shift($result_array) : false;
    }
  
  
  
  public static function find_by_sql($sql="") {
    global $database;
    $result_set = $database->query($sql);
    $object_array = array();
    while ($row = $database->fetch_array($result_set)) {
      $object_array[] = self::instantiate($row);
    }
    return $object_array;
  }

	public static function count_all() {
	  global $database;
	  $sql = "SELECT COUNT(*) FROM ".self::$table_name;
    $result_set = $database->query($sql);
	  $row = $database->fetch_array($result_set);
    return array_shift($row);
	}

	private static function instantiate($record) {
		// Could check that $record exists and is an array
    $object = new self;
		// Simple, long-form approach:
		// $object->id 				= $record['id'];
		// $object->username 	= $record['username'];
		// $object->password 	= $record['password'];
		// $object->first_name = $record['first_name'];
		// $object->last_name 	= $record['last_name'];
		
		// More dynamic, short-form approach:
		foreach($record as $attribute=>$value){
		  if($object->has_attribute($attribute)) {
		    $object->$attribute = $value;
		  }
		}
		return $object;
	}
	
	private function has_attribute($attribute) {
	  // We don't care about the value, we just want to know if the key exists
	  // Will return true or false
	  return array_key_exists($attribute, $this->attributes());
	}

	protected function attributes() { 
		// return an array of attribute names and their values
	  $attributes = array();
	  foreach(self::$db_fields as $field) {
	    if(property_exists($this, $field)) {
	      $attributes[$field] = $this->$field;
	    }
	  }
	  return $attributes;
	}
	
	protected function sanitized_attributes() {
	  global $database;
	  $clean_attributes = array();
	  // sanitize the values before submitting
	  // Note: does not alter the actual value of each attribute
	  foreach($this->attributes() as $key => $value){
	    $clean_attributes[$key] = $database->escape_value($value);
	  }
	  return $clean_attributes;
	}
	
	public function save() {
	  // A new record won't have an id yet.
	  return isset($this->id) ? $this->update() : $this->create();
	}
	
	public function create() {
		global $database;
		// Don't forget your SQL syntax and good habits:
		// - INSERT INTO table (key, key) VALUES ('value', 'value')
		// - single-quotes around all values
		// - escape all values to prevent SQL injection
		$attributes = $this->sanitized_attributes();
	  $sql = "INSERT INTO ".self::$table_name." (";
		$sql .= join(", ", array_keys($attributes));
	  $sql .= ") VALUES ('";
		$sql .= join("', '", array_values($attributes));
		$sql .= "')";
	  if($database->query($sql)) {
	    $this->id = $database->insert_id();
	    return true;
	  } else {
	    return false;
	  }
	}

	public function update() {
	  global $database;
		// Don't forget your SQL syntax and good habits:
		// - UPDATE table SET key='value', key='value' WHERE condition
		// - single-quotes around all values
		// - escape all values to prevent SQL injection
		$attributes = $this->sanitized_attributes();
		$attribute_pairs = array();
		foreach($attributes as $key => $value) {
		  $attribute_pairs[] = "{$key}='{$value}'";
		}
		$sql = "UPDATE ".self::$table_name." SET ";
		$sql .= join(", ", $attribute_pairs);
		$sql .= " WHERE id=". $database->escape_value($this->id);
	  $database->query($sql);
	  return ($database->affected_rows() == 1) ? true : false;
	}

	public function delete() {
		global $database;
		// Don't forget your SQL syntax and good habits:
		// - DELETE FROM table WHERE condition LIMIT 1
		// - escape all values to prevent SQL injection
		// - use LIMIT 1
	  $sql = "DELETE FROM ".self::$table_name;
	  $sql .= " WHERE id=". $database->escape_value($this->id);
	  $sql .= " LIMIT 1";
	  $database->query($sql);
	  return ($database->affected_rows() == 1) ? true : false;
	
		// NB: After deleting, the instance of User still 
		// exists, even though the database entry does not.
		// This can be useful, as in:
		//   echo $user->first_name . " was deleted";
		// but, for example, we can't call $user->update() 
		// after calling $user->delete().
	}

}

?>