<?php
    ob_start();
    require_once("../includes/login-session.php"); 
    require_once("../includes/initialize.php"); 
    if (!$login_session->is_admin_logged_in()) { redirect_to("../../admin/"); }
    else { $user_level = Levels::find_by_username($login_session->admin_id); if($user_level->id_card != 1){ redirect_to("../../admin/"); } }
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title>Signature - SASAPA ID Card</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
        <meta content="Coderthemes" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
        <link rel="shortcut icon" href="../assets/images/favicon.ico">

        <!-- Plugins css -->
        <link href="../assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />

	    <!-- App css -->
	    <link href="../assets/css/config/default/bootstrap.min.css" rel="stylesheet" type="text/css" id="bs-default-stylesheet" />
	    <link href="../assets/css/config/default/app.min.css" rel="stylesheet" type="text/css" id="app-default-stylesheet" />

	    <link href="../assets/css/config/default/bootstrap-dark.min.css" rel="stylesheet" type="text/css" id="bs-dark-stylesheet" />
	    <link href="../assets/css/config/default/app-dark.min.css" rel="stylesheet" type="text/css" id="app-dark-stylesheet" />

	    <!-- icons -->
        <link href="../assets/css/icons.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/css/custom.css" rel="stylesheet" type="text/css" />

    </head>

    <!-- body start -->
    <body class="loading" data-layout='{"mode": "light", "width": "fluid", "menuPosition": "fixed", "sidebar": { "color": "light", "size": "default", "showuser": false}, "topbar": {"color": "dark"}, "showRightSidebarOnPageLoad": true}'>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include_once("include/header.php")?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include_once("include/sidebar.php")?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">                            
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row justify-content-between">
                                            <div class="col-auto">
                                                <h4 class="page-title">Signature</h4>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="text-md-end mt-3 mt-md-0">
                                                    <a href="index.php" class="btn btn-light waves-effect waves-light"><i class="mdi mdi-keyboard-backspace me-1"></i> back</a>
                                                    <button type="button" class="btn btn-success waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#custom-modal"><i class="mdi mdi-plus-circle me-1"></i> Add New</button>
                                                    
                                                </div>
                                            </div><!-- end col-->
                                        </div> <!-- end row -->
                                    </div> <!-- end card-body-->
                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->


                        <div class="row">

                            <?php 
                                $signature = Signature::find_all();

                                foreach ($signature as $signature) {
                            ?>
                                    <div class="col-sm-6 col-xl-3">
                                        <!-- Simple card -->
                                        <div class="card">
                                            <img class="card-img-top img-fluid" style="padding: 10%;" src="<?php echo "../".$signature->signature_photo; ?>" alt="Signature image">
                                            <div class="card-body">
                                                <h5 class="card-title text-center"><?php echo $signature->name; ?></h5>
                                                <a href="delete-signature.php?sid=<?php echo $signature->id; ?>" class="btn btn-danger w-100 waves-effect waves-light delete-signature">
                                                    <i class="mdi mdi-trash-can-outline me-1"></i> Delete
                                                </a>
                                            </div>
                                        </div>
                                    </div><!-- end col -->

                            <?php } ?>
                        </div>
                            
                        
                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">
                                <script>document.write(new Date().getFullYear())</script> &copy; Powered by <a href="http://synergyace.com/" target="_blank" class="text-danger">Synergy Ace Pvt. Ltd.</a> 
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <!-- Modal -->
        <div class="modal fade" id="custom-modal" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-light">
                        <h4 class="modal-title" id="myCenterModalLabel">Add New Signature</h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                    </div>
                    <div class="modal-body p-4">
                        <form action="add-signature-db.php" method="POST" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="name" class="form-label">Signature Name</label>
                                <input name="name" type="text" class="form-control" id="name" placeholder="Enter Signature name">
                            </div>
                            <div class="mb-3">
                                <div class="mb-3">
                                    <label for="example-fileinput" class="form-label">Upload Signature</label>
                                    <input name="signature_photo" type="file" accept="image/x-png,image/gif,image/jpeg" id="example-fileinput" class="form-control">
                                </div>
                            </div>
                            <div class="text-end">
                                <button type="submit" class="btn btn-success waves-effect waves-light"><i class="mdi mdi-content-save me-1"></i> Save</button>
                                <button type="button" class="btn btn-danger waves-effect waves-light" data-bs-dismiss="modal"><i class="mdi mdi-close-circle me-1"></i> Cancel</button>
                            </div>
                        </form>
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->



        <!-- Success Alert Modal -->
        <div id="success-alert-modal" class="modal fade" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content modal-filled <?php
                    $message = output_message($message);
                    if(strpos($message, 'Signature Added Successfully') !== false){echo " bg-success ";} else {echo " bg-danger "; }
                ?> ">
                    <div class="modal-body p-4">
                        <div class="text-center">
                            <i class="dripicons-checkmark h1 text-white"></i>
                            <h4 class="mt-2 text-white">Success!</h4>
                            <p class="mt-3 text-white"><?php echo output_message($message); ?></p>
                            <button type="button" class="btn btn-light my-2" data-bs-dismiss="modal">Ok</button>
                        </div>
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->


        

        <!-- Vendor js -->
        <script src="../assets/js/vendor.min.js"></script>

        <script src="../assets/libs/selectize/js/standalone/selectize.min.js"></script>
        <script src="../assets/libs/mohithg-switchery/switchery.min.js"></script>
        <script src="../assets/libs/multiselect/js/jquery.multi-select.js"></script>
        <script src="../assets/libs/select2/js/select2.min.js"></script>
        <script src="../assets/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
        <script src="../assets/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
        <script src="../assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
        <script src="../assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>

        

        <!-- Init js-->
        <script src="../assets/js/pages/form-advanced.init.js"></script>

        <!-- App js -->
        <script src="../assets/js/app.min.js"></script>

        <script type="text/javascript">

            $('.delete-signature').click(function() {
                var x = confirm("Are you sure you want Delete");
                if (x){
                    return true;
                } else{
                    return false;
                }
            });
        </script>

        <?php
            $message = output_message($message); 
            if(!empty($message)){
                echo "<script> $( document ).ready(function() { $('#success-alert-modal').modal('show'); });</script>";
            } 
        ?>
    </body>
</html>