<?php
    ob_start();
    require_once("../includes/login-session.php"); 
    require_once("../includes/initialize.php"); 
    if (!$login_session->is_admin_logged_in()) { redirect_to("../../admin/"); }
    else { $user_level = Levels::find_by_username($login_session->admin_id); if($user_level->id_card != 1){ redirect_to("../../admin/"); } }

    ini_set('display_errors', 1);
    error_reporting(E_ALL);

    
    $user_level = Levels::find_by_username($login_session->admin_id);
    $company = Company::find_by_id($user_level->company_id);


    if(strlen($user_level->company_id) < 2){ $company_id = "0".$user_level->company_id; }
    else { $company_id = $user_level->company_id; }

?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title><?php echo $company->name; ?> Employees - SASAPA ID Card</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
        <meta content="Coderthemes" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
        <link rel="shortcut icon" href="../assets/images/favicon.ico">

        <!-- Plugins css -->
        <link href="../assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />

	    <!-- App css -->
	    <link href="../assets/css/config/default/bootstrap.min.css" rel="stylesheet" type="text/css" id="bs-default-stylesheet" />
	    <link href="../assets/css/config/default/app.min.css" rel="stylesheet" type="text/css" id="app-default-stylesheet" />

	    <link href="../assets/css/config/default/bootstrap-dark.min.css" rel="stylesheet" type="text/css" id="bs-dark-stylesheet" />
        <link href="../assets/css/config/default/app-dark.min.css" rel="stylesheet" type="text/css" id="app-dark-stylesheet" />

        <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />


	    <!-- icons -->
        <link href="../assets/css/icons.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/css/custom.css" rel="stylesheet" type="text/css" />

        <style type="text/css">
            #employees-datatable{
                margin-top: 10px;
            }

            #employees-datatable thead tr th{
                background: #f1556c;
                color: #fff;
            }

            .emp_check_val{ margin-left: -15px; }

            .employee_photo{cursor: pointer;}

            table.dataTable thead .sorting_desc, table.dataTable thead .sorting_asc{
                background-image:none !important;
            }

            .dataTables_wrapper .dataTables_filter{
                float: left;
                padding: 0 0 10px 0;
            }
        </style>

    </head>

    <!-- body start -->
    <body class="loading" data-layout='{"mode": "light", "width": "fluid", "menuPosition": "fixed", "sidebar": { "color": "light", "size": "default", "showuser": false}, "topbar": {"color": "dark"}, "showRightSidebarOnPageLoad": true}'>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include_once("include/header.php")?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include_once("include/sidebar.php")?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">                            
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row justify-content-between">
                                            <div class="col-auto">
                                                <h4 class="page-title"><?php echo $company->name; ?></h4>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="text-md-end mt-3 mt-md-0">
                                                    <a href="index.php" class="btn btn-light waves-effect waves-light"><i class="mdi mdi-keyboard-backspace me-1"></i> back</a>
                                                    <a href="upload-employee-data.php?cid=<?php echo $company->id; ?>" class="btn btn-success waves-effect waves-light"><i class="mdi mdi-file-excel me-1"></i> Upload Data</a>
                                                    <a href="upload-employee-photo.php?cid=<?php echo $company->id; ?>" class="btn btn-info waves-effect waves-light"><i class="mdi mdi-account me-1"></i> Upload Photo</a>

                                                    <form action="export-idcard.php?cid=<?php echo $company_id; ?>" target="_blank" method="POST" enctype="multipart/form-data" style="display: inline-block;">
                                                        <input type="hidden" class="idcard_holders" value="" name="idcard_holders">
                                                        <button type="submit" class="btn btn-danger waves-effect waves-light"><i class="mdi mdi-file-pdf me-1"></i> Export PDF</button>
                                                    </form>
                                                    
                                                </div>
                                            </div><!-- end col-->
                                        </div> <!-- end row -->
                
                                        <div class="table-responsive">
                                            <table id="employees-datatable" class="table dt-responsive nowrap w-100">
                                            <!-- <table class="table table-centered table-nowrap table-striped" id="employees-datatable"> -->
                                                <thead>
                                                    <tr>
                                                        <th>
                                                            <input type="checkbox" class="form-check-input" id="emp_check_all">
                                                        </th>
                                                        <th>Name</th>
                                                        <th>Code</th>
                                                        <th>Phone</th>
                                                        <th>Designation</th>
                                                        <th>Blood Group</th>
                                                        <th>Aadhaar No.</th>
                                                        <th>Photo</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                <?php
                                                    $employees = Employee::find_by_company_id($company_id);

                                                    foreach ($employees as $employees) {                                                        
                                                ?>
                                                        <tr>
                                                            <td align="center">
                                                                <input type="checkbox" value="<?php echo $employees->emp_code; ?>" class="form-check-input emp_check_val" id="customCheck2">
                                                            </td>
                                                            <td class="table-user"><?php echo $employees->emp_name; ?></td>
                                                            <td><?php echo $employees->emp_code; ?></td>
                                                            <td><?php echo $employees->emp_contact; ?></td>
                                                            <td><?php echo $employees->emp_designation; ?></td>
                                                            <td><?php //echo $employees->blood_group; ?></td>
                                                            <td><?php echo $employees->emp_aadhar_no; ?></td>
                                                            
                                                            <td align="center">
                                                                <?php
                                                                    if($employees->status >= 1){
                                                                        echo "<span class='badge bg-soft-success text-success'>Active</span>";
                                                                    } else { echo "<span class='badge bg-soft-danger text-danger'>Inactive</span>"; }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                <?php 
                                                    } 

                                                    $non_app_employees = NonAppEmployee::find_all();

                                                    foreach ($non_app_employees as $non_app_employees) {                                                        
                                                ?>
                                                        <tr>
                                                            <td align="center">
                                                                <input type="checkbox" value="<?php echo $non_app_employees->emp_code; ?>" class="form-check-input emp_check_val" id="customCheck2">
                                                            </td>
                                                            <td class="table-user"><?php echo $non_app_employees->emp_name; ?></td>
                                                            <td><?php echo $non_app_employees->emp_code; ?></td>
                                                            <td><?php echo $non_app_employees->emp_contact; ?></td>
                                                            <td><?php echo $non_app_employees->emp_designation; ?></td>
                                                            <td><?php //echo $non_app_employees->blood_group; ?></td>
                                                            <td><?php echo $non_app_employees->emp_aadhar_no; ?></td>
                                                            
                                                            <td align="center">
                                                                <?php
                                                                    if($non_app_employees->status >= 1){
                                                                        echo "<span class='badge bg-soft-success text-success'>Active</span>";
                                                                    } else { echo "<span class='badge bg-soft-danger text-danger'>Inactive</span>"; }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                <?php } ?>
                                                    
                                                </tbody>
                                            </table>
                                        </div>

                                    </div> <!-- end card-body-->
                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->
                            
                        
                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">
                                <script>document.write(new Date().getFullYear())</script> &copy; Powered by <a href="http://synergyace.com/" target="_blank" class="text-danger">Synergy Ace Pvt. Ltd.</a> 
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <!-- Modal -->
        <div class="modal fade" id="employee-photo" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-success">
                        <h4 class="modal-title text-white" id="myCenterModalLabel"></h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                    </div>
                    <div class="modal-body p-4"></div>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="custom-modal" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-light">
                        <h4 class="modal-title" id="myCenterModalLabel">Add New Opportunities</h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                    </div>
                    <div class="modal-body p-4">
                        <form action="add-company-db.php" method="POST" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="name" class="form-label">Company Name</label>
                                <input name="name" type="text" class="form-control" id="name" placeholder="Enter company name">
                            </div>
                            <div class="mb-3">
                                <div class="mb-3">
                                    <label for="example-fileinput" class="form-label">Company Logo</label>
                                    <input name="company_logo" type="file" id="example-fileinput" class="form-control">
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Select Template</label> <br/>
                                <select name="idcard_template" class="form-control" data-toggle="select2" data-width="100%">
                                    <option>Template 1</option>
                                    <option>Template 2</option>
                                    <option>Template 3</option>
                                    <option>Template 4</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Select Signature</label> <br/>
                                <select name="signature_name" class="form-control" data-toggle="select2" data-width="100%">
                                    <option>Rohit</option>
                                    <option>Sandeep</option>
                                </select>
                            </div>

        
                            <div class="text-end">
                                <button type="submit" class="btn btn-success waves-effect waves-light"><i class="mdi mdi-content-save me-1"></i> Save</button>
                                <button type="button" class="btn btn-danger waves-effect waves-light" data-bs-dismiss="modal"><i class="mdi mdi-close-circle me-1"></i> Cancel</button>
                            </div>
                        </form>
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->



        <!-- Success Alert Modal -->
        <div id="success-alert-modal" class="modal fade" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content modal-filled <?php 
                    $message = output_message($_SESSION['message']);
                    if(strpos($message, 'successfully Uploaded') !== false){echo " bg-success ";} else {echo " bg-danger "; }
                ?> ">
                    <div class="modal-body p-4">
                        <div class="text-center">
                            <?php if(strpos($message, 'successfully Uploaded') !== false){?>
                                <i class="mdi mdi-check-circle-outline h1 text-white"></i>
                                <h4 class="mt-2 text-white">Success!</h4>
                            <?php }else {?>
                                <i class="mdi mdi-close-circle-outline h1 text-white"></i>
                                <h4 class="mt-2 text-white">Failed!</h4>
                            <?php }?>
                            <p class="mt-3 text-white"><?php echo output_message($message); ?></p>
                            <button type="button" class="btn btn-light my-2" data-bs-dismiss="modal">Ok</button>
                        </div>
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->


        

        <!-- Vendor js -->
        <script src="../assets/js/vendor.min.js"></script>

        <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
        <script src="../assets/libs/selectize/js/standalone/selectize.min.js"></script>
        <script src="../assets/libs/mohithg-switchery/switchery.min.js"></script>
        <script src="../assets/libs/multiselect/js/jquery.multi-select.js"></script>
        <script src="../assets/libs/select2/js/select2.min.js"></script>
        <!-- <script src="../assets/libs/jquery-mockjax/jquery.mockjax.min.js"></script> -->
        <script src="../assets/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
        <script src="../assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
        <script src="../assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>
        <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>

        

        <!-- Init js-->
        <!-- <script src="../assets/js/pages/form-advanced.init.js"></script> -->

        <!-- App js -->
        <script src="../assets/js/app.min.js"></script>

        <script type="text/javascript">

            $(document).ready(function() {
                var employees_list = [];
                var idcard_holders = "idcard_holders_<?php echo $company_id; ?>";

                $('.employee_photo').click(function() {
                    var data_name   = $(this).attr('data-name');
                    var data_img    = $(this).attr('data-img');
                    $("#employee-photo .modal-title").html(data_name);
                    $("#employee-photo .modal-body").html("<div align='center'><img src='../documents/photos/"+data_img+"'></div>");
                });
                
                
                $("#emp_check_all").click(function(){

                    if(this.checked == true){
                        employees_list = [];

                        $( ".emp_check_val" ).each(function( index ) {
                          employees_list.push($(this).attr("value"));
                        });

                        $(".idcard_holders").val(employees_list);
                    } else {
                        employees_list = [];
                        $(".idcard_holders").val(employees_list);
                    }
                    $('.emp_check_val').not(this).prop('checked', this.checked);

                    document.cookie = idcard_holders+"="+employees_list;
                    console.log(employees_list);
                });

                                
                $(".emp_check_val").click(function(){

                    if(this.checked == true){
                        if(!employees_list.includes($(this).attr("value"))){
                            employees_list.push($(this).attr("value"));
                        }
                    } else {
                        if(employees_list.includes($(this).attr("value"))){
                            for(var i=0;i<employees_list.length;i++){
                                if(employees_list[i] == $(this).attr("value")){
                                    employees_list.splice(i,1);
                                }
                            }
                        }
                    }
                    console.log(employees_list);
                    $(".idcard_holders").val(employees_list);
                    document.cookie = idcard_holders+"="+employees_list;

                });


                $('#employees-datatable').DataTable({
                    "pageLength": 50,
                    "bLengthChange" : false,
                    "order": [[ 1, "asc" ]],
                    "ordering": true,
                });

                var table = $('#employees-datatable').DataTable();
 
                table.on( 'search.dt', function () {

                    $("#emp_check_all").click(function(){

                        if(this.checked == true){
                            employees_list = [];

                            $( ".emp_check_val" ).each(function( index ) {
                              employees_list.push($(this).attr("value"));
                            });

                            $(".idcard_holders").val(employees_list);
                        } else {
                            employees_list = [];
                            $(".idcard_holders").val(employees_list);
                        }
                        $('.emp_check_val').not(this).prop('checked', this.checked);

                        document.cookie = idcard_holders+"="+employees_list;
                        console.log(employees_list);
                    });

                    $(".emp_check_val").click(function(){

                        if(this.checked == true){
                            if(!employees_list.includes($(this).attr("value"))){
                                employees_list.push($(this).attr("value"));
                            }
                        } else {
                            if(employees_list.includes($(this).attr("value"))){
                                for(var i=0;i<employees_list.length;i++){
                                    if(employees_list[i] == $(this).attr("value")){
                                        employees_list.splice(i,1);
                                    }
                                }
                            }
                        }
                        console.log(employees_list);
                        $(".idcard_holders").val(employees_list);
                        document.cookie = idcard_holders+"="+employees_list;

                    });

                    console.log("Hello");
                } );

            });


            $('.delete-employee').click(function() {
                var x = confirm("Are you sure you want Delete");
                if (x){
                    return true;
                } else{
                    return false;
                }
            });
        </script>

        <?php
            $message = $_SESSION['message'];
            if(!empty($message)){
                echo "<script> $( document ).ready(function() { $('#success-alert-modal').modal('show'); });</script>";
            }
            unset($_SESSION['message']);
        ?>
    </body>
</html>