<?php
	ob_start();
    require_once("../includes/login-session.php"); 
	require_once("../includes/initialize.php"); 

	ini_set('display_errors', 1);
	error_reporting(E_ALL);

    if (!$login_session->is_admin_logged_in()) { redirect_to("../../admin/"); }
    else { $user_level = Levels::find_by_username($login_session->admin_id); if($user_level->id_card != 1){ redirect_to("../../admin/"); } }

	date_default_timezone_set('Asia/Calcutta');


	/*
	foreach ($_POST as $key => $value) {
		echo htmlspecialchars($key)." = ".htmlspecialchars($value)."<br>";
	}

	foreach ($_FILES['company_logo'] as $key => $value) {
		echo htmlspecialchars($key)." = ".htmlspecialchars($value)."<br>";
	};

	return false;

	*/



	if(!isset($_GET['cid']) || empty($_GET['cid'])){
		return false;
	} else {
        $company = Company::find_by_id($_GET['cid']);
        $company_template = CompanyTemplate::find_by_cid($company->id);
	
?>


<div class="modal-header bg-light">
    <h4 class="modal-title" id="myCenterModalLabel">Edit <?php echo $company->name; ?></h4>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
</div>
<div class="modal-body p-4">
    <form action="edit-company-db.php" method="POST" enctype="multipart/form-data">
        <input name="cid" type="hidden" class="form-control" id="name" value="<?php echo $company->id; ?>">
        <div class="mb-3">
            <label for="name" class="form-label">Company Name</label>
            <input name="name" readonly type="text" class="form-control" id="name" placeholder="Enter company name" value="<?php echo $company->name; ?>">
        </div>
        <div class="mb-3">
            <div class="mb-3">
                <label for="example-fileinput" class="form-label">Company Logo</label>
                <input name="company_logo" type="file" id="example-fileinput" class="form-control">
            </div>
        </div>
        <div class="mb-3">
            <label class="form-label">Select Template</label> <br/>
            <select name="idcard_template" class="form-control" data-toggle="select2" data-width="100%">
                <option value="">Select Template</option>
                <option <?php if($company_template){ if($company_template->template == "Template 1"){echo " selected ";}} ?>>Template 1</option>
                <option <?php if($company_template){ if($company_template->template == "Template 2"){echo " selected ";}} ?>>Template 2</option>
                <option <?php if($company_template){ if($company_template->template == "Template 3"){echo " selected ";}} ?>>Template 3</option>
                <option <?php if($company_template){ if($company_template->template == "Template 4"){echo " selected ";}} ?>>Template 4</option>
            </select>
        </div>
        <div class="mb-3">
            <label class="form-label">Select Signature</label> <br/>
            <select name="signature_name" class="form-control" data-toggle="select2" data-width="100%">
                <option value="">Select Signature</option>
                <?php
                    $signature = Signature::find_all();
                    foreach($signature as $signature){
                        echo "<option ";
                        if($company_template){ if($company_template->signature == $signature->id){echo " selected ";} }
                        echo "value='{$signature->id}'>{$signature->name}</option>";
                    }
                ?>
            </select>
        </div>


        <div class="text-end">
            <button type="submit" class="btn btn-success waves-effect waves-light"><i class="mdi mdi-content-save me-1"></i> Update</button>
            <button type="button" class="btn btn-danger waves-effect waves-light" data-bs-dismiss="modal"><i class="mdi mdi-close-circle me-1"></i> Cancel</button>
        </div>
    </form>
</div>
<?php } ?>




<!-- Init js-->
<script src="../assets/js/pages/form-advanced.init.js"></script>