<?php
    require_once("../includes/initialize.php"); 
    if (!$session->is_admin_logged_in()) { redirect_to("logout.php"); }
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title>SASAPA - ID Card</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
        <meta content="Coderthemes" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
        <link rel="shortcut icon" href="../assets/images/favicon.ico">

        <!-- Plugins css -->
        <link href="../assets/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
        <link href="../assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />

	    <!-- App css -->
	    <link href="../assets/css/config/default/bootstrap.min.css" rel="stylesheet" type="text/css" id="bs-default-stylesheet" />
	    <link href="../assets/css/config/default/app.min.css" rel="stylesheet" type="text/css" id="app-default-stylesheet" />

	    <link href="../assets/css/config/default/bootstrap-dark.min.css" rel="stylesheet" type="text/css" id="bs-dark-stylesheet" />
	    <link href="../assets/css/config/default/app-dark.min.css" rel="stylesheet" type="text/css" id="app-dark-stylesheet" />

	    <!-- icons -->
        <link href="../assets/css/icons.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/css/custom.css" rel="stylesheet" type="text/css" />
        <style type="text/css">
            .template-modal, .signature_btn{ cursor: pointer; }
        </style>

    </head>

    <!-- body start -->
    <body class="loading" data-layout='{"mode": "light", "width": "fluid", "menuPosition": "fixed", "sidebar": { "color": "light", "size": "default", "showuser": false}, "topbar": {"color": "dark"}, "showRightSidebarOnPageLoad": true}'>

        <!-- Begin page -->
        <div id="wrapper">

            <!-- Topbar Start -->
            <?php include_once("include/header.php")?>
            <!-- end Topbar -->

            <!-- ========== Left Sidebar Start ========== -->
            <?php include_once("include/sidebar.php")?>
            <!-- Left Sidebar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">
                     
                        <div class="row">
                            <div class="col-xl-12 order-xl-1 order-2">
                                <div class="card mb-2">
                                    <div class="card-body">
                                        <div class="row justify-content-between">
                                            <div class="col-auto">
                                                <h4 class="page-title">Dashboard</h4>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="text-md-end mt-3 mt-md-0">
                                                    <button type="button" class="btn btn-success waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#custom-modal"><i class="mdi mdi-plus-circle me-1"></i> Add New</button>
                                                </div>
                                            </div><!-- end col-->
                                        </div> <!-- end row -->
                                    </div> <!-- end card-body-->
                                </div> <!-- end card-->
                            </div>

                            <?php

                                $sql = "Select * from company where status = 1 order by id ASC";
                                $company = Company::find_by_sql($sql);

                                foreach ($company as $company) {
                                    
                            ?>

                            <div class="col-xl-6 order-xl-1 order-2">
                                <div class="card mb-2">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-sm-12">
                                                <div class="d-flex align-items-start">
                                                    <img class="d-flex align-self-center me-3" src="../<?php echo $company->logo_img; ?>" alt="<?php echo $company->name; ?>" height="100" width="100">

                                                    <div class="w-100">
                                                        <div class="text-sm-end" style="float: right;">
                                                            <a href="javascript:void(0);" class="action-icon text-info"> <i class="mdi mdi-square-edit-outline"></i></a>
                                                            <a href="delete-company.php?id=<?php echo $company->id; ?>" class="action-icon text-danger delete-company"> <i class="mdi mdi-delete"></i></a>
                                                        </div>

                                                        <h4 class="mt-0 mb-2 font-16"><?php echo $company->name; ?></h4>
                                                        <p class="mb-0"><a href="<?php echo "employees-list.php?cid=".$company->id; ?>">Employees: <?php
                                                            $emp_count = Employees::count_employees($company->id); echo $emp_count;
                                                        ?></a> </p>
                                                        <div style="margin-top: 10px;"></div>
                                                        <div class="text-left mt-3 mt-sm-0">
                                                            <div class="badge font-14 bg-soft-success text-success p-1 template-modal" data-tid="<?php echo $company->template; ?>" data-bs-toggle="modal" data-bs-target="#<?php
                                                                if($company->template == 'Template 1'){echo "template-modal-1";}
                                                                if($company->template == 'Template 2'){echo "template-modal-2";}
                                                                if($company->template == 'Template 3'){echo "template-modal-3";}
                                                            ?>">Template: <?php echo $company->template; ?></div>
                                                            <?php $signature = Signature::find_by_id($company->signature); ?>
                                                            <div class="badge font-14 bg-soft-info text-info p-1 signature_btn" data-img="<?php echo $signature->signature_photo; ?>" data-bs-toggle="modal" data-bs-target="#signature-modal">Signature: <?php echo $signature->name; ?></div>
                                                        </div>  
                                                    </div>
                                                </div>
                                            </div>
                                        </div> <!-- end row -->
                                    </div>
                                </div> <!-- end card-->
                            </div>
                            <?php } ?>

                            <!--<div class="col-xl-6 order-xl-1 order-2">
                                <div class="card mb-2">
                                    <div class="card-body">
                                        <div class="row align-items-center">
                                            <div class="col-sm-12">
                                                <div class="d-flex align-items-start">
                                                    <img class="d-flex align-self-center me-3 rounded-circle" src="../assets/images/companies/apple.png" alt="Generic placeholder image" height="64">

                                                    <div class="w-100">
                                                        <div class="text-sm-end" style="float: right;">
                                                            <a href="javascript:void(0);" class="action-icon text-info"> <i class="mdi mdi-square-edit-outline"></i></a>
                                                            <a href="javascript:void(0);" class="action-icon text-danger"> <i class="mdi mdi-delete"></i></a>
                                                        </div>

                                                        <h4 class="mt-0 mb-2 font-16">Apple Inc.</h4>
                                                        <p class="mb-0"><b>Employees:</b> 90</p>
                                                        <div style="margin-top: 10px;"></div>
                                                        <div class="text-left mt-3 mt-sm-0">
                                                            <div class="badge font-14 bg-soft-success text-success p-1">Template: Template One</div>
                                                            <div class="badge font-14 bg-soft-info text-info p-1">Signature: Rohit</div>
                                                        </div>  
                                                    </div>
                                                </div>
                                            </div>
                                        </div> 
                                    </div>
                                </div> 
                            </div>-->
                            
                            
                        </div>
                        <!-- end row -->
                        
                    </div> <!-- container -->

                </div> <!-- content -->

                <!-- Footer Start -->
                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">
                                <script>document.write(new Date().getFullYear())</script> &copy; Powered by <a href="http://synergyace.com/" target="_blank" class="text-danger">Synergy Ace Pvt. Ltd.</a> 
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <!-- Modal -->
        <div class="modal fade" id="template-modal-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header bg-success">
                        <h5 class="modal-title text-white" id="scrollableModalTitle">Template 1</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <img style="width: 49%;" src='../documents/templates/demo/sasapa-id-card-5-front.png' />
                        <img style="width: 49%; float: right;" src='../documents/templates/demo/sasapa-id-card-5-back.png' />
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="template-modal-2" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header bg-success">
                        <h5 class="modal-title text-white" id="scrollableModalTitle">Template 2</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <img style="width: 49%;" src='../documents/templates/demo/sasapa-id-card-7-front.png' />
                        <img style="width: 49%; float: right;" src='../documents/templates/demo/sasapa-id-card-7-back.png' />
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="template-modal-3" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header bg-success">
                        <h5 class="modal-title text-white" id="scrollableModalTitle">Template 3</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <img style="width: 49%;" src='../documents/templates/demo/sasapa-id-card-8-front.png' />
                        <img style="width: 49%; float: right;" src='../documents/templates/demo/sasapa-id-card-8-back.png' />
                    </div>
                </div>
            </div>
        </div>


        <!-- Modal -->
        <div class="modal fade" id="signature-modal" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content"></div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="custom-modal" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-light">
                        <h4 class="modal-title" id="myCenterModalLabel">Add New Opportunities</h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                    </div>
                    <div class="modal-body p-4">
                        <form action="add-company-db.php" method="POST" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="name" class="form-label">Company Name</label>
                                <input name="name" type="text" class="form-control" id="name" placeholder="Enter company name">
                            </div>
                            <div class="mb-3">
                                <div class="mb-3">
                                    <label for="example-fileinput" class="form-label">Company Logo</label>
                                    <input name="company_logo" type="file" id="example-fileinput" class="form-control">
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Select Template</label> <br/>
                                <select name="idcard_template" class="form-control" data-toggle="select2" data-width="100%">
                                    <option>Template 1</option>
                                    <option>Template 2</option>
                                    <option>Template 3</option>
                                    <option>Template 4</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Select Signature</label> <br/>
                                <select name="signature_name" class="form-control" data-toggle="select2" data-width="100%">
                                    <?php
                                        $signature = Signature::find_all();
                                        foreach($signature as $signature){
                                            echo "<option value='{$signature->id}'>{$signature->name}</option>";
                                        }
                                    ?>
                                </select>
                            </div>

        
                            <div class="text-end">
                                <button type="submit" class="btn btn-success waves-effect waves-light"><i class="mdi mdi-content-save me-1"></i> Save</button>
                                <button type="button" class="btn btn-danger waves-effect waves-light" data-bs-dismiss="modal"><i class="mdi mdi-close-circle me-1"></i> Cancel</button>
                            </div>
                        </form>
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->



        <!-- Success Alert Modal -->
        <div id="success-alert-modal" class="modal fade" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content modal-filled <?php
                    $message = output_message($message);
                    if(strpos($message, 'Company Added Successfully') !== false){echo " bg-success ";} else {echo " bg-danger "; }
                ?> ">
                    <div class="modal-body p-4">
                        <div class="text-center">
                            <i class="dripicons-checkmark h1 text-white"></i>
                            <h4 class="mt-2 text-white">Success!</h4>
                            <p class="mt-3 text-white"><?php echo output_message($message); ?></p>
                            <button type="button" class="btn btn-light my-2" data-bs-dismiss="modal">Ok</button>
                        </div>
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->


        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="../assets/js/vendor.min.js"></script>

        <script src="../assets/libs/selectize/js/standalone/selectize.min.js"></script>
        <script src="../assets/libs/mohithg-switchery/switchery.min.js"></script>
        <script src="../assets/libs/multiselect/js/jquery.multi-select.js"></script>
        <script src="../assets/libs/select2/js/select2.min.js"></script>
        <script src="../assets/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
        <script src="../assets/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
        <script src="../assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
        <script src="../assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>

        

        <!-- Init js-->
        <script src="../assets/js/pages/form-advanced.init.js"></script>

        <!-- App js -->
        <script src="../assets/js/app.min.js"></script>

        <script type="text/javascript">
            $( document ).ready(function() { 

                $('.signature_btn').click(function() {
                    var data_img = $(this).attr('data-img');
                    $("#signature-modal .modal-content").html("<img src='../"+data_img+"'>")
                });

            });



            $('.delete-company').click(function() {
                var x = confirm("Are you sure you want Delete");
                if (x){
                    return true;
                } else{
                    return false;
                }
            });
        </script>

        <?php
            $message = output_message($message); 
            if(!empty($message)){
                echo "<script> $( document ).ready(function() { $('#success-alert-modal').modal('show'); });</script>";
            } 
        ?>
    </body>
</html>